***************************************************************
*MODELO PARA EXPLICAR EL PUNTAJE PROMEDIO DEL LOGRO EDUCATIVO 
*EN LENGUAJE Y COMUNICACIN DEL SEXTO GRADO DE PRIMARIA*
***************************************************************
*Para utilizar la base de datos de este modelo desarga el archivo BDeducacion.csv y
*escribe la ubicacin del archivo en la siguiente lnea en lugar de TUDIRECTORIO
import delimited "TUDIRECTORIO\BDeducacion.csv", case(upper) clear
*Se definen las variables de datos tipo panel para entidades federativas y ao
xtset CVE_ENT ANIO2
*A continuacin se calcula la matriz de correlaciones
pwcorr LNPPLC_6P_E P_TELFIJA ESCPRIM_INT  

*MODELO FINAL:
xtreg  LNPPLC_6P_E P_TELFIJA ESCPRIM_INT  REGION2 REGION4 REGION5 REGION7 REGION9  , re robust

*VIF PARA VALORAR LA PRESENCIA DE MULTICOLINEALIDAD
regress  LNPPLC_6P_E P_TELFIJA ESCPRIM_INT  REGION2 REGION4 REGION5 REGION7 REGION9 
vif
* Los valores de VIF son menores a 5, por lo que no hay sospechas de multicolinealidad.

*PRUEBA DE HAUSMAN PARA DEFINIR EFECTOS FIJOS O ALEATORIOS POR ENTIDAD FEDERATIVA
xtreg  LNPPLC_6P_E P_TELFIJA ESCPRIM_INT  REGION2 REGION4 REGION5 REGION7 REGION9  , re
estimates store random24
xtreg  LNPPLC_6P_E P_TELFIJA ESCPRIM_INT  REGION2 REGION4 REGION5 REGION7 REGION9  , fe
estimates store fixed24
hausman  fixed24 random24
*No se rechaza Ho con 99% de confianza, por lo que se usarn efectos aleatorios para las entidades federativas

*PRUEBA PARA DEFINIR EFECTOS FIJOS O ALEATORIOS PARA EL TIEMPO (AOS)
xtreg  LNPPLC_6P_E P_TELFIJA ESCPRIM_INT  REGION2 REGION4 REGION5 REGION7 REGION9   i.ANIO2 , re
testparm i.ANIO2 
*No se rechaza Ho con 99% de confianza, por lo que se usarn efectos aleatorios para los aos


***************************************************
*MODELO PARA EXPLICAR EL LOGARITMO NATURAL DEL PIB*
***************************************************
*Para utilizar la base de datos de este modelo desarga el archivo BDdesarrolloeconmico.csv y
*escribe la ubicacin del archivo en la siguiente lnea en lugar de TUDIRECTORIO
import delimited "TUDIRECTORIO\BDdesarrolloeconmico.csv", case(upper) clear
*A continuacin se calcula la matriz de correlaciones
pwcorr  LNPIB_MEX_DES   LNINV_FIJAB   LNPO LNINPC_COMUN REFORMA T_anual_2014

*MODELO FINAL:
regress  LNPIB_MEX_DES   LNINV_FIJAB   LNPO LNINPC_COMUN REFORMA T_ANUAL_2014, robust

*VIF PARA VALORAR LA EXISTENCIA DE MULTICOLINEALIDAD
regress  LNPIB_MEX_DES   LNINV_FIJAB   LNPO LNINPC_COMUN REFORMA T_ANUAL_2014
vif
* Los valores de VIF son menores a 20, por lo que no hay sospechas de multicolinealidad.

*HAUSMAN AUMENTADA PARA VALIDAR LA PRESENCIA DE ENDOGENEIDAD
*Se sospecha la variable LNPO presente problemas de endogeneidad y se estima 
*una regresin auxiliar de LNPO en funcin de variables exgenes e instrumentales
regress  LNPO LNINPC_COMUN REFORMA T_ANUAL_2014 LAGLNPO, robust
*Se guardan las predicciones del modelo y los residuales
predict LNPO_OLS99
predict RES_LNPO_OLS99, res
*Se estima el modelo principal incluyendo las variables estimadas
 regress LNPIB_MEX_DES   LNINV_FIJAB   LNPO_OLS99  LNINPC_COMUN REFORMA T_ANUAL_2014 RES_LNPO_OLS99,robust
 testparm RES*
*No se rechaza Ho con 99% de confianza, por lo que no hay problemas de endogeneidad.



***********************************************************
*MODELO PARA EXPLICAR EL LOGARITMO NATURAL DE LA POBLACIN 
*QUE NO SE ENCUENTRA EN SITUACIN DE POBREZA
***********************************************************
*Para utilizar la base de datos de este modelo desarga el archivo BDdesarrollosocial.csv y
*escribe la ubicacin del archivo en la siguiente lnea en lugar de TUDIRECTORIO
import delimited "TUDIRECTORIO\BDdesarrollosocial.csv", case(upper) clear
*Se definen las variables de datos tipo panel para entidades federativas y ao
xtset CVE_ENT ANIO
*A continuacin se calcula la matriz de correlaciones
pwcorr LNMDP_NO_POBREZA_E  LNTB_MORTALIDAD    LNT_TELMOVIL  LNP_TELFIJA  LNPO LNANIOS_PROMESC  LNMUJ_15OMEMSYS

*MODELO FINAL:
xtivreg LNMDP_NO_POBREZA_E  LNTB_MORTALIDAD    LNT_TELMOVIL  LNP_TELFIJA  (  LNPO  = LNANIOS_PROMESC     LNMUJ_15OMEMSYS ) REGION2  REGION5 REGION7 REGION9,   re
*Las variables LNANIOS_PROMESC y LNMUJ_15OMEMSYS se incluyen para corregir la endogeneidad de LNPO
	 
*VIF PARA VALORAR LA EXISTENCIA DE MULTICOLINEALIDAD
regress LNMDP_NO_POBREZA_E  LNTB_MORTALIDAD    LNT_TELMOVIL  LNP_TELFIJA  LNPO  REGION2  REGION5 REGION7 REGION9
vif
*Los valores de VIF son menores a 5, por lo que no hay sospechas de multicolinealidad.

*PRUEBAS DE EFECTOS FIJOS Y ALEATORIOS
xtivreg LNMDP_NO_POBREZA_E  LNTB_MORTALIDAD    LNT_TELMOVIL  LNP_TELFIJA  (  LNPO  = LNANIOS_PROMESC     LNMUJ_15OMEMSYS ) REGION2  REGION5 REGION7 REGION9,   re
estimates store random15
xtivreg LNMDP_NO_POBREZA_E  LNTB_MORTALIDAD    LNT_TELMOVIL  LNP_TELFIJA  (  LNPO  = LNANIOS_PROMESC     LNMUJ_15OMEMSYS ) REGION2  REGION5 REGION7 REGION9,   fe
estimates store fixed15
hausman  fixed15 random15
*No se rechaza Ho con 99% de confianza, por lo que se usarn efectos aleatorios para las entidades federativas

*PRUEBA PARA DEFINIR EFECTOS FIJOS O ALEATORIOS PARA EL TIEMPO (AOS)
xtivreg LNMDP_NO_POBREZA_E  LNTB_MORTALIDAD    LNT_TELMOVIL  LNP_TELFIJA  (  LNPO  = LNANIOS_PROMESC LNMUJ_15OMEMSYS ) REGION2  REGION5 REGION7 REGION9 i.ANIO,   re
testparm i.ANIO
*No se rechaza Ho con 99% de confianza, por lo que se usarn efectos aleatorios para los aos
 
